package demo;

import cn.quantgroup.xyqb.Bootstrap;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.SpringBootTest.WebEnvironment;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;


/**
 * 控制层测试用例
 * @author renwc
 * @date 2018-01-05
 */
@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest(classes = Bootstrap.class, webEnvironment= WebEnvironment.RANDOM_PORT)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class WebTest {

    @Resource
    private TestRestTemplate restTemplate;

    @Test
    public void contextLoads() {
        Assert.assertTrue(true);
    }

    @Test
    public void test() {
        ResponseEntity<String> phil = restTemplate.getForEntity("/{model}/test", String.class, "user");
        Assert.assertEquals(HttpStatus.OK, phil.getStatusCode());
    }

}

