package cn.quantgroup.xyqb.remote.codec;

import cn.quantgroup.xyqb.model.JiGuangResponseParam;
import com.google.gson.Gson;
import feign.FeignException;
import feign.Response;
import feign.codec.Decoder;

import javax.crypto.Cipher;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

public class JiGuangDecoder implements Decoder {
    private final Gson gson;
    private final String privateKey;

    public JiGuangDecoder(Gson gson,String privateKey) {
        this.gson = gson;
        this.privateKey = privateKey;
    }

    @Override
    public Object decode(Response response, Type type) throws IOException, FeignException {
        JiGuangResponseParam responseParam;
        responseParam = gson.fromJson(response.body().asReader(), JiGuangResponseParam.class);
        if(responseParam!=null && responseParam.getCode()==8000){
            try {
                responseParam.setPhone(decrypt(responseParam.getPhone(),privateKey));
            } catch (Exception e) {
                responseParam.setPhone(null);
            }
        }
        return responseParam;
    }


    private static String decrypt(String cryptedString, String privateKey) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey));
        PrivateKey generatedPrivate = KeyFactory.getInstance("RSA").generatePrivate(keySpec);

        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(Cipher.DECRYPT_MODE, generatedPrivate);

        byte[] b = Base64.getDecoder().decode(cryptedString);
        return new String(cipher.doFinal(b));
    }
}
