package cn.quantgroup.xyqb.controller.external.queryLog;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.entity.UserQueryLog;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.UserQueryInfo;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserQueryLogService;
import cn.quantgroup.xyqb.service.user.IUserService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * Created by zenglibin on 17/06/13.
 */
@RestController
@RequestMapping("/query")
public class UserQueryLogController {

  private static final Logger LOGGER = LoggerFactory.getLogger(UserQueryLogController.class);

  @Autowired
  private IUserQueryLogService userQueryLogService;
  @Autowired
  private IUserDetailService userDetailService;

  @Value("${xyqb.paycenter.url}")
  private String payCenterUrl;
  @Value("${xyqb.paycenter.id}")
  private String payCenterId;

  @Autowired
  private IHttpService httpService;

  @RequestMapping("/queryLog")
  public JsonResult queryLog(String date,Long pageId,Long PageSize) {
    //List<UserQueryLog> userQueryLogs=userQueryLogService.findByDate(date);

    return null;
  }

  @RequestMapping("/queryUserInfo")
  public JsonResult queryForResult(String keys,String userName, String columns) {
    //手机号、身份证号、userId
    //checkKeysType;
    String[] values=keys.split(";");
    List<String> queryV= Arrays.asList(values);
    List<UserQueryInfo> userQueryInfos=new ArrayList<UserQueryInfo>();

    List<UserDetail> userDetails=new ArrayList<UserDetail>();
    //用户userIds
//    List<Long> userIds=new ArrayList<Long>();
//    for(String s:queryV){
//      long uid=Long.valueOf(s);
//      userIds.add(uid);
//    }



    //userDetails=userDetailService.findByUserIdIn(userIds);

    //userDetails=userDetailService.findByPhoneNos(queryV);

    userDetails=userDetailService.findByIdnos(queryV);


    return JsonResult.buildSuccessResult("查询成功",userDetails.size());


//    UserQueryLog uql=new UserQueryLog();
//    uql.setLoginUserName(userName);
//    uql.setQueryCondition("userId");//phoneNo,IdNo
//    uql.setResultAmount(234l);
//    uql.setQueryItems(columns);//userId,手机号，身份证号，银行卡号，地址
//    userQueryLogService.save(uql);
//    return null;
  }

  @RequestMapping("/query")
  public JsonResult outputToExcel(String keys,String userName, String columns) {



    UserQueryLog uql=new UserQueryLog();
    uql.setLoginUserName(userName);
    uql.setQueryCondition("userId");//phoneNo,IdNo
    uql.setResultAmount(234l);
    uql.setQueryItems(columns);//userId,手机号，身份证号，银行卡号，地址
    userQueryLogService.save(uql);
    return null;
  }

  private String getBankCardsByPhoneNos(String phoneNo){

    HashMap<String, String> parameters = new HashMap<>();
    parameters.put("phoneNo", phoneNo);
    parameters.put("merchantId", payCenterId);
    //访问用户中心查询用户银行卡接口
    String resultStr = httpService.post(payCenterUrl + "ex/common_bank_card/list", parameters);
    StringBuffer cardList=null;
    try{
      JsonObject obj = new JsonParser().parse(resultStr).getAsJsonObject();
      if(obj.get("data")!=null){
        JsonArray array = obj.get("data").getAsJsonArray();
        for(JsonElement jsonElement : array){
          JsonObject jo = jsonElement.getAsJsonObject();
          String cardNo=jo.get("cardNo").getAsString();
          cardList.append(cardNo+",");
        }
      }

    }catch(Exception e){

    }
    return cardList.toString();
  }
}
