package cn.quantgroup.xyqb.service.sms;

import cn.quantgroup.sms.SmsSender;
import cn.quantgroup.xyqb.controller.external.sms.SmsController;
import cn.quantgroup.xyqb.model.JsonResult;

/**
 * 短信发送服务
 *
 * @author mengfan.feng
 * @time 2015-09-21 11:24
 */
public interface ISmsService {

    SmsSender getSmsSender();

    void sendAfterRegister(String phoneNo);

    void sendAfterRegister(String phoneNo, String contentId);

    /**
     * 验证手机号和验证码是否匹配
     *
     * @param phoneNo          手机号
     * @param verificationCode 验证码（短信/语音）
     * @return
     */
    boolean verifyPhoneAndCode(String phoneNo, String verificationCode);

    /**
     * 是否需要重新发送短信验证码
     *
     * @param phoneNo
     * @return
     */
    boolean needResendCode(String phoneNo);

    /**
     *
     * @param phoneNo
     * @param threshold
     * @param isDelTryCount 是否删除尝试登录次数
     * @return
     */
    boolean needResendCode(String phoneNo,Long threshold,boolean isDelTryCount);

    /**
     * 删除验证码缓存
     * @param phoneNo
     */
   void deleteCodeFromCache(String phoneNo);

    /**
     * 只删除code缓存不删除尝试缓存
     * @param phoneNo
     */
   void deleteOnlyCodeFromCache(String phoneNo);

	/**
	 * 新版本短信验证码
	 * 必须与SmsController#sendVerificationCode2New同步
	 * @param phoneNo     - 手机号
	 * @param deviceId    - 设备id
	 * @param isApp       -
	 * @param appName     -
	 * @param smsMerchant - 短信模板/类型
	 * @return
	 * @see SmsController#sendVerificationCode2New(String, String, String, boolean, String, String)
	 */
	JsonResult sendVerificationCode2New(String phoneNo, String randomCode, String deviceId, boolean b, String appName,
			String smsMerchant, String clientIp);

}
