package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.tech.db.DSType;
import cn.quantgroup.tech.db.TargetDataSource;
import cn.quantgroup.xyqb.entity.ProductLoginEntity;
import cn.quantgroup.xyqb.repository.IProductLoginRepository;
import cn.quantgroup.xyqb.service.user.IProductLoginService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by 11 on 2016/12/29.
 */
@Slf4j
@Service
public class ProductLoginServiceImpl implements IProductLoginService {
    @Autowired
    private IProductLoginRepository productLoginRepository;

    @Override
    @TargetDataSource(type = DSType.SLAVE)//查询从库
    public ProductLoginEntity findSlaveByPloginInfo(String institutionId, String productId, Long userId) {
        ProductLoginEntity productLogin = productLoginRepository.findByInstitutionIdAndProductIdAndExtensionAccountId(institutionId, productId, userId);
        return productLogin;
    }
}
