package cn.quantgroup.xyqb.controller.internal.user.center;

import cn.quantgroup.xyqb.entity.OauthClientDetailsEntity;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.user.IOauthClientDetailsService;
import cn.quantgroup.xyqb.service.user.IOauthLoginInfoService;
import cn.quantgroup.xyqb.service.user.ISmsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by 11 on 2017/3/22.
 */
@Slf4j
@RestController
@RequestMapping("/oauthClient")
public class OauthClientDetailsController {
    @Autowired
    private IOauthClientDetailsService oauthClientDetailsService;

    @Autowired
    private IOauthLoginInfoService oauthLoginInfoService;

    @Autowired
    private ISmsService smsService;

    @PostMapping("/getOauthClient")
    public JsonResult getOauthClient(String clientId) {
        OauthClientDetailsEntity oauthClientDetailsEntity = oauthClientDetailsService.findFirstByClientId(clientId);
        return JsonResult.buildSuccessResultGeneric(oauthClientDetailsEntity);
    }

    @PostMapping("/addLoginInfo")
    public JsonResult addLoginInfo(String tenantId, String phoneNo) {
        User user = new User();
        user.setPhoneNo(phoneNo);
        user.setId(new Long("111111"));
        oauthLoginInfoService.addLoginInfo(user, tenantId);
        return JsonResult.buildSuccessResultGeneric("12");
    }

    @PostMapping("/sendSms")
    public JsonResult sendSms(Long tenantId, String phoneNo) {
        String code = smsService.sendSms(tenantId, "login", phoneNo);
        return JsonResult.buildSuccessResultGeneric(code);
    }

}
