package cn.quantgroup.xyqb.entity;



import cn.quantgroup.xyqb.entity.baseEntity.PartitionEntity;
import cn.quantgroup.xyqb.model.Gender;
import cn.quantgroup.xyqb.util.StringUtils;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 *
 * @author: Li JianHua
 * @Date: 2021/9/23
 * @Time: 11:02
 * Description: No Description
 */
@Entity
@Table(name = "customer_info")
public class CustomerInfoEntity extends PartitionEntity implements Serializable {
    private static final long serialVersionUID = -3639362579605273102L;

    private final static String CLASS_NAME = CustomerInfoEntity.class.getSimpleName();

    @Id
    @Column(name = "ID", nullable = false)
    private long id;

    @Column(name = "CUSTOMER_ID", nullable = false)
    private long customerId;

    @Column(name = "INSTITUTION_ID", nullable = false, length = 4)
    private String institutionId;

    @Column(name = "AVATAR_URL", nullable = true, length = 255)
    private String avatarUrl;

    @Column(name = "NICK_NAME", nullable = true, length = 50)
    private String nickName;

    @Column(name = "CITY", nullable = true, length = 36)
    private String city;

    @Column(name = "CITY_CODE", nullable = true)
    private Long cityCode;

    @Column(name = "COUNTRY", nullable = true, length = 50)
    private String country;

    @Column(name = "LANGUAGE", nullable = true, length = 30)
    private String language;

    @Column(name = "SOURCE_OPEN_ID", nullable = true, length = 128)
    private String sourceOpenId;

    @Column(name = "PRIVILEAGE", nullable = true, length = 255)
    private String privileage;

    @Column(name = "PROVINCE", nullable = true, length = 30)
    private String province;

    @Column(name = "PROVINCE_CODE", nullable = true)
    private Long provinceCode;

    @Column(name = "SEX", nullable = true)
    private Gender sex;

    @Column(name = "UNION_ID", nullable = true, length = 128)
    private String unionId;

    @Column(name = "UTM_SOURCE", nullable = true, length = 50)
    private String utmSource;

    @Column(name = "NAME", nullable = true, length = 50)
    private String name;

    @Column(name = "ID_CARD_NO", nullable = true, length = 32)
    private String idCardNo;

    @Column(name = "ID_CARD_TYPE", nullable = true)
    private Byte idCardType;

    @Column(name = "BIRTHDAY", nullable = true, length = 30)
    private String birthday;

    @Column(name = "PRODUCT_ID", nullable = false)
    private String productId;

    @Column(name = "SOURCE_TYPE", nullable = true, length = 255)
    private String sourceType;

    @Column(name = "TELEPHONE", nullable = true, length = 32)
    private String telephone;


    public long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(long customerId) {
        this.customerId = customerId;
    }

    public String getInstitutionId() {
        return institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public String getAvatarUrl() {
        return avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Long getCityCode() {
        return cityCode;
    }

    public void setCityCode(Long cityCode) {
        this.cityCode = cityCode;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getSourceOpenId() {
        return sourceOpenId;
    }

    public void setSourceOpenId(String sourceOpenId) {
        this.sourceOpenId = sourceOpenId;
    }

    public String getPrivileage() {
        return privileage;
    }

    public void setPrivileage(String privileage) {
        this.privileage = privileage;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public Long getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(Long provinceCode) {
        this.provinceCode = provinceCode;
    }

    public Gender getSex() {
        return sex;
    }

    public void setSex(Gender sex) {
        this.sex = sex;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getUtmSource() {
        return utmSource;
    }

    public void setUtmSource(String utmSource) {
        this.utmSource = utmSource;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdCardNo() {
        return idCardNo;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public Byte getIdCardType() {
        return idCardType;
    }

    public void setIdCardType(Byte idCardType) {
        this.idCardType = idCardType;
    }

    public String getBirthday() {
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    @Override
    public String getPersistentKey() {
        return StringUtils.toDelimitedString(CLASS_NAME, customerId, institutionId);
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }
}
