package cn.quantgroup.xyqb.service.page.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.entity.UserExtInfo;
import cn.quantgroup.xyqb.model.Tuple;
import cn.quantgroup.xyqb.service.page.IPageService;
import cn.quantgroup.xyqb.service.page.bean.BasePageType;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserExtInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Miraculous on 2017/1/3.
 */
@Service
public class PageServiceImpl implements IPageService {

    private Map<String, BasePageType[]> routerDefinetion;
    @Autowired
    private IUserDetailService userDetailService;
    private BasePageType pageIdNo = new BasePageType("name", false) {
        @Override
        public boolean canPass(User user) {
            UserDetail userDetail = userDetailService.findByUserId(user.getId());
            return userDetail != null;
        }
    };
    @Autowired
    private IUserExtInfoService userExtInfoService;
    private BasePageType pageUserFinance = new BasePageType("info", false) {
        @Override
        public boolean canPass(User user) {
            UserExtInfo extInfo = userExtInfoService.findByUserId(user.getId());
            return null != extInfo;
        }
    };



    @PostConstruct
    private void init() {
        routerDefinetion = new HashMap<>();

        routerDefinetion.put("cashTarget1", new BasePageType[]{
                pageIdNo, pageUserFinance
        });

        routerDefinetion.put("cashTarget4", new BasePageType[]{
                pageIdNo
        });
        routerDefinetion.put("cashTarget5", new BasePageType[]{
        });
    }

    @Override
    public Tuple<String, Boolean> nextPage(User user, String target, String currentPage) {
        if (user == null) {
            return new Tuple<>("", false);
        }
        BasePageType[] processLists = routerDefinetion.getOrDefault(target, null);
        if (processLists == null) {
            return new Tuple<>("", false);
        }
        if (processLists.length == 0) {
            return new Tuple<>("", true);
        }
        boolean isBeforeCurrentPage = true;
        for (BasePageType page : processLists) {
            if (!page.canPass(user)) {
                return new Tuple<>(page.getName(), false);
            }
            if (!isBeforeCurrentPage && page.getNeedShow()) {
                return new Tuple<>(page.getName(), false);
            }
            if (page.getName().equals(currentPage)) {
                isBeforeCurrentPage = false;
            }
        }
        return new Tuple<>("", true);
    }

}
