package cn.quantgroup.xyqb.entity;

import cn.quantgroup.motan.retbean.XUserExtInfo;
import cn.quantgroup.xyqb.constant.enums.*;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * Created by 11 on 2016/12/30.
 */
@Data
@Entity
@Table(name = "user_ext_info")
public class UserExtInfo extends BaseEntity implements Serializable {

    private static final long serialVersionUID = -1L;
    @Column(name = "user_id")
    private Long userId;
    @Column(name = "means_of_income_payment")
    private IncomeEnum incomeEnum = IncomeEnum.UNKNOWN;
    @Column(name = "monthly_income_range")
    private IncomeRangeEnum incomeRangeEnum = IncomeRangeEnum.UNKNOWN;
    @Column(name = "occupation")
    private OccupationEnum occupationEnum = OccupationEnum.UNKNOWN;
    @Column(name = "education")
    private EducationEnum educationEnum = EducationEnum.UNKNOWN;
    @Column(name = "has_car")
    private Boolean hasCar = false;
    @Column(name = "has_social_security")
    private Boolean hasSocialSecurity = false;
    @Column(name = "has_house")
    private Boolean hasHouse = false;
    @Column(name = "has_credit_card")
    private Boolean hasCreditCard = false;
    @Column(name = "marry_status")
    private MaritalStatus marryStatus = MaritalStatus.UNKNOWN;

    public XUserExtInfo toXUserExtInfo() {
        XUserExtInfo xUserExtInfo = new XUserExtInfo();
        xUserExtInfo.setId(getId());
        xUserExtInfo.setUserId(this.userId);
        xUserExtInfo.setEducationEnum(cn.quantgroup.motan.enums.EducationEnum.valueOf(this.educationEnum.name()));
        xUserExtInfo.setIncomeEnum(cn.quantgroup.motan.enums.IncomeEnum.valueOf(this.incomeEnum.name()));
        xUserExtInfo.setIncomeRangeEnum(cn.quantgroup.motan.enums.IncomeRangeEnum.valueOf(this.incomeRangeEnum.name()));
        xUserExtInfo.setOccupationEnum(cn.quantgroup.motan.enums.OccupationEnum.valueOf(this.occupationEnum.name()));
        xUserExtInfo.setHasCar(this.hasCar);
        xUserExtInfo.setHasSocialSecurity(this.hasSocialSecurity);
        xUserExtInfo.setHasCreditCard(this.hasCreditCard);
        xUserExtInfo.setMarryStatus(cn.quantgroup.motan.enums.MaritalStatus.valueOf(this.marryStatus.name()));
        xUserExtInfo.setCreatedAt(getCreatedAt());
        xUserExtInfo.setUpdateAt(getUpdatedAt());
        return xUserExtInfo;
    }
}
