package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.constant.enums.*;
import cn.quantgroup.xyqb.entity.UserExtInfo;
import lombok.Data;

/**
 * Created by Miraculous on 2017/2/13.
 */
@Data
public class UserExtInfoRet {
    private static final long serialVersionUID = -1L;

    private Long id;
    private Long userId;
    private IncomeEnum incomeEnum;
    private IncomeRangeEnum incomeRangeEnum;
    private OccupationEnum occupationEnum;
    private EducationEnum educationEnum;
    private boolean hasCar;
    private boolean hasSocialSecurity;
    private boolean hasHouse;
    private boolean hasCreditCard;
    private MaritalStatus marryStatus;
    private Long createdAt;
    private Long updateAt;

    private static boolean defaultBoolean(Boolean k) {
        return k == null ? false : k;
    }

    public static UserExtInfoRet getUserExtInfoRet(UserExtInfo extInfo) {
        if (extInfo == null) {
            return null;
        }
        UserExtInfoRet ret = new UserExtInfoRet();
        ret.setUserId(extInfo.getUserId());
        ret.setId(extInfo.getId());
        ret.setIncomeEnum(extInfo.getIncomeEnum());
        ret.setIncomeRangeEnum(extInfo.getIncomeRangeEnum());
        ret.setOccupationEnum(extInfo.getOccupationEnum());
        ret.setEducationEnum(extInfo.getEducationEnum());
        ret.setHasCar(defaultBoolean(extInfo.getHasCar()));
        ret.setHasSocialSecurity(defaultBoolean(extInfo.getHasSocialSecurity()));
        ret.setHasHouse(defaultBoolean(extInfo.getHasHouse()));
        ret.setHasCreditCard(defaultBoolean(extInfo.getHasCreditCard()));
        ret.setMarryStatus(extInfo.getMarryStatus());
        ret.setCreatedAt(extInfo.getCreatedAt().getTime());
        ret.setUpdateAt(extInfo.getUpdatedAt().getTime());
        return ret;
    }
}
