package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.tech.db.DSType;
import cn.quantgroup.tech.db.TargetDataSource;
import cn.quantgroup.user.enums.OccupationEnum;
import cn.quantgroup.xyqb.entity.UserExtInfo;
import cn.quantgroup.xyqb.repository.IUserExtInfoRepository;
import cn.quantgroup.xyqb.service.user.IUserExtInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by Miraculous on 2017/1/3.
 */
@Slf4j
@Service
public class UserExtInfoServiceImpl implements IUserExtInfoService {

    @Autowired
    private IUserExtInfoRepository userExtInfoRepository;

    @Override
//    @Cacheable(value = "userextinfocache", key = "'extinfo' + #userId", unless = "#result == null", cacheManager = "cacheManager")
    public UserExtInfo findByUserId(Long userId) {
        return userExtInfoRepository.findByUserId(userId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    @CacheEvict(value = "userextinfocache", key = "'extinfo' + #info.userId", cacheManager = "cacheManager")
    public UserExtInfo save(UserExtInfo info) {
        return userExtInfoRepository.save(info);
    }

    @Override
    @TargetDataSource(type = DSType.SLAVE)//查询从库
    public List<UserExtInfo> findByCreatedAtAfterAndCreatedAtBeforeAndOccupationEnum(Timestamp start, Timestamp end) {
        return userExtInfoRepository.findByCreatedAtAfterAndCreatedAtBeforeAndOccupationEnum(start, end, OccupationEnum.STUDENT);
    }
}
