package cn.quantgroup.xyqb.controller.api.v2;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.controller.req.v2.LoginReq;
import cn.quantgroup.xyqb.controller.req.v2.UserInfoConvertReq;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.LoginBean;
import cn.quantgroup.xyqb.service.v2.LoginContext;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

@RestController
@RequestMapping("/api/v2/oauth")
public class OauthApiV2Controller implements IBaseController {
    private final LoginContext loginContext;

    public OauthApiV2Controller(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    /**
     * 对外内部登录接口
     * @param loginReq LoginReq
     * @return JsonResult<LoginBean>
     * @see <a href="http://yapi.quantgroups.com/project/17/interface/api/65779">对外统一登录接口</a>
     */
    @PostMapping("/login")
    public JsonResult<LoginBean> login(@RequestBody LoginReq loginReq){
        if (loginReq.getClientType() == null) {
            Long registeredFrom = getRegisteredFrom();
            Integer clientType = Objects.equals(registeredFrom,217L) || Objects.equals(registeredFrom,214L) ? ClientType.APP.ordinal():ClientType.H5.ordinal();
            loginReq.setClientType(clientType);
        }
        return JsonResult.buildSuccessResultGeneric(loginContext.interLogin(loginReq));
    }

    @PostMapping("/shop-map/user-data-convert")
    public JsonResult<UserInfoConvertReq> shopMapDataConvert(@RequestBody UserInfoConvertReq req){

        //手机号是否存在--注册 登录
        //微信是否存在-  若存在，和手机号是否匹配相同
        //头像昵称
        Integer tenantId = getTenantId();
        req.setTenantId(tenantId);
        return JsonResult.buildSuccessResultGeneric(loginContext.shopMapDataConvert(req));
    }
}
