package cn.quantgroup.xyqb.remote.config;

import cn.quantgroup.xyqb.remote.codec.JiGuangDecoder;
import com.google.gson.Gson;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

public class JiGuangConfiguration {

    @Bean
    public Decoder feignDecoder(Gson gson,@Value("${user.auth.manager.Urora.properties.privateKey}") String privateKey) {
        return new JiGuangDecoder(gson,privateKey);
    }

    @Bean
    public BasicAuthRequestInterceptor basicAuthRequestInterceptor(
            @Value("${user.auth.manager.Urora.properties.appKey}") String user,  @Value("${user.auth.manager.Urora.properties.masterSecret}") String password
    ) {
        return new BasicAuthRequestInterceptor(user, password);
    }
}
