package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserBtRegister;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.service.user.IUserBtRegisterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;

import java.util.Objects;

//@Component
public class BtRegisteredEventListener implements ApplicationListener<RegisterEvent> {

    @Autowired
    private IUserBtRegisterService userBtRegisterService;


    @Override
    public void onApplicationEvent(RegisterEvent event) {
        UserRegisterParam userRegisterParam = event.getUserRegisterParam();
        Long channelId = userRegisterParam.getChannelId();
        User user = userRegisterParam.getUser();
        Long btRegisterChannelId = userRegisterParam.getBtRegisterChannelId();
        if (Objects.isNull(user) || !Objects.equals(channelId, Constants.Channel.BAITIAO)) {
            return;
        }
        UserBtRegister userBtRegister = new UserBtRegister();
        userBtRegister.setUserId(user.getId());
        if (null == btRegisterChannelId) {
            userBtRegister.setRegisterBtMerchantId(0L);
        } else {
            userBtRegister.setRegisterBtMerchantId(btRegisterChannelId);
        }
        userBtRegister.setIsActive(true);
        userBtRegisterService.save(userBtRegister);
    }
}
