package cn.quantgroup.xyqb.util;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import java.util.Calendar;
import java.util.Date;

/**
 * joda-time
 * <p>
 * Date: 2019/11/6
 * Time: 上午11:18
 *
 * @author: yangrui
 */
public class DateUtils {

    public static final String STANDARD_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String YMD_FORMAT = "yyyy-MM-dd";

    public static Date strToDate(String dateTimeStr, String formatStr) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern(formatStr);
        DateTime dateTime = dateTimeFormatter.parseDateTime(dateTimeStr);
        return dateTime.toDate();
    }

    /**
     * yyyy-MM-dd -> yyyy-MM-dd HH:mm:ss => yyyy-MM-dd 00:00:00
     *
     * @param date
     * @param formatStr
     * @return
     */
    public static String dateToStr(Date date, String formatStr) {
        if (date == null) {
            return StringUtils.EMPTY;
        }
        DateTime dateTime = new DateTime(date);
        return dateTime.toString(formatStr);
    }

    public static int daysBetween(DateTime fromDate, DateTime toDate) {
        return Days.daysBetween(fromDate, toDate).getDays();
    }

    /**
     * 计算当前时间到当天 23:59:59.999 时间差,
     * 返回时间差(单位秒)
     *
     * @return
     */
    public static long getSeconds() {
        Calendar endOfDay = Calendar.getInstance();
        endOfDay.set(Calendar.HOUR_OF_DAY, 23);
        endOfDay.set(Calendar.MINUTE, 59);
        endOfDay.set(Calendar.SECOND, 59);
        endOfDay.set(Calendar.MILLISECOND, 999);
        long timeStamp = endOfDay.getTimeInMillis();
        long now = System.currentTimeMillis();
        return (timeStamp - now) / 1000;
    }

    public static void main(String[] args) {
        System.out.println(dateToStr(strToDate("2019-11-06", DateUtils.YMD_FORMAT), "yyyy-MM-dd HH:mm:ss"));
    }
}
