package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.service.wechat.IWechatService;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class WechatPhoneNoUpdateEventListener implements ApplicationListener<PhoneNoUpdateEvent> {

    @Autowired
    private IWechatService wechatService;

    @Override
    public void onApplicationEvent(PhoneNoUpdateEvent event) {
        log.info("onApplicationEvent cn.quantgroup.xyqb.event.WechatPhoneNoUpdateEventListener start");
        String oldPhoneNo = event.getOldPhoneNo();
        User user = event.getUser();
        WechatUserInfo userInfo = wechatService.findWechatUserInfoByPhoneNo(oldPhoneNo);
        if (Objects.isNull(userInfo)) {
            return;
        }
        if (Objects.isNull(userInfo.getPhoneNo())) {
            return;
        }

        userInfo.setPhoneNo(user.getPhoneNo());
        wechatService.saveWechatUserInfo(userInfo);
    }
}
