package cn.quantgroup.xyqb.event;

import cn.qg.ec.model.base.BusinessEventBaseInfo;
import cn.qg.ec.model.user.UserBaseInfoEvent;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.risk.uereventcollecting.UserEventCollectingUtil;
import cn.quantgroup.xyqb.service.user.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/12/22 16:21
 * @description：用变更身份证号的时候发送给大数据
 * @modified By：
 * @version:
 */
@Slf4j
@Component
public class UserDetailUpdateEventListener implements ApplicationListener<UserDetailUpdateEvent> {
    @Autowired
    private IUserService userService;


    @Override
    public void onApplicationEvent(UserDetailUpdateEvent userDetailUpdateEvent) {
        UserDetail userDetail = userDetailUpdateEvent.getUserDetail();
        log.info("用户实名认证事件监听,userDetail:{}", userDetail);

        if (null == userDetail) {
            log.error("来了个假的?????");
            return;
        }

        if(null == userDetail.getIdNo()){
            log.warn("实名认证没有身份证号?userId:{}",userDetail.getUserId());
            return;
        }

        UserBaseInfoEvent.UserBaseInfoEventBuilder builder = UserBaseInfoEvent.builder();
        builder.maskIdNo(userDetail.getIdNo());

        User user = userService.findById(userDetail.getUserId());

        if (null == user) {
            log.error("用户竟然不存在userDetail:{}", userDetail);
            return;
        }
        BusinessEventBaseInfo.BusinessEventBaseInfoBuilder baseInfoBuilder = BusinessEventBaseInfo.builder();
        baseInfoBuilder.userUuid(user.getUuid());

        builder.businessEventBaseInfo(baseInfoBuilder.build());

        UserEventCollectingUtil.addEvent(builder.build());
        log.info("用户实名认证事件监听结束userId:{}",userDetail.getUserId());
    }
}
