package cn.quantgroup.xyqb.event;

import cn.qg.ec.model.base.BusinessEventBaseInfo;
import cn.qg.ec.model.user.UserBaseInfoEvent;
import cn.quantgroup.user.enums.EducationEnum;
import cn.quantgroup.user.enums.IncomeRangeEnum;
import cn.quantgroup.user.enums.MaritalStatus;
import cn.quantgroup.user.enums.OccupationEnum;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserExtInfo;
import cn.quantgroup.xyqb.risk.uereventcollecting.UserEventCollectingUtil;
import cn.quantgroup.xyqb.service.user.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/12/22 14:25
 * @description：监听
 * @modified By：
 * @version:
 */
@Slf4j
@Component
public class UserExtInfoSaveEventListener implements ApplicationListener<UserExtInfoSaveEvent> {

    @Autowired
    private IUserService userService;

    @Override
    public void onApplicationEvent(UserExtInfoSaveEvent userExtInfoSaveEvent) {

        UserExtInfo userExtInfo = userExtInfoSaveEvent.getUserExtInfo();

        log.info("用户开始保存扩展信息userExtInfo:{}", userExtInfo);

        EducationEnum educationEnum = userExtInfo.getEducationEnum();
        IncomeRangeEnum incomeRangeEnum = userExtInfo.getIncomeRangeEnum();
        MaritalStatus marryStatus = userExtInfo.getMarryStatus();
        OccupationEnum occupationEnum = userExtInfo.getOccupationEnum();

        UserBaseInfoEvent.UserBaseInfoEventBuilder builder = UserBaseInfoEvent.builder();
        builder.subEventType(UserBaseInfoEvent.SubEventType.user_occupation);
        if (null != educationEnum) {
            builder.education(String.valueOf(educationEnum.ordinal()));
        }
        if (null != incomeRangeEnum) {
            builder.income(String.valueOf(incomeRangeEnum.ordinal()));
        }
        if (null != marryStatus) {
            builder.maritalStatus(String.valueOf(marryStatus.ordinal()));
        }
        if (null != occupationEnum) {
            builder.occupation(String.valueOf(occupationEnum.ordinal()));
        }

        BusinessEventBaseInfo.BusinessEventBaseInfoBuilder baseInfoBuilder = BusinessEventBaseInfo.builder();

        User user = userService.findById(userExtInfo.getUserId());
        if (null == user) {
            log.error("没找到用户,应该不存在这种情况");
        }
        baseInfoBuilder.userId(user.getUuid());
        builder.businessEventBaseInfo(baseInfoBuilder.build());

        UserEventCollectingUtil.addEvent(builder.build());
    }
}
