package demo;

import org.junit.Ignore;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import java.util.Arrays;
import java.util.Collection;

import static org.junit.jupiter.api.Assertions.assertEquals;

@Tag("Parameters")
@RunWith(value = Parameterized.class)
public class ParametersTest {
	private String key;
	private int value;
	public ParametersTest(String key, int value) {
		this.key = key;
		this.value = value;
	}

	@Parameterized.Parameters
	public Collection<Object[]> data() {
		Object[][] data = new Object[][] {{"1", 1}, {"2", 2}, {"3", 3}, {"4", 4}};
		return Arrays.asList(data);
	}

	@Test
	public void pushTest() {
		System.out.println("Parameterized is : key="+ key+", value="+value);
	}

//	@Ignore("Not Ready to Run")
//	@Test
//	@DisplayName("My 1st JUnit 5 test! 😎")
//	void myFirstTest(TestInfo testInfo) {
//		assertEquals(2, Math.addExact(1, 1), "1 + 1 should equal 2");
//		assertEquals("My 1st JUnit 5 test! 😎", testInfo.getDisplayName(), () -> "TestInfo is injected correctly");
//	}

}