package cn.quantgroup.xyqb.service.auth;

import java.util.Map;

/**
 * @author xufei on 2018/1/5.
 */
public interface IUserAuthorizedService {
    /**
     * 该身份证是否有对应的实名账户
     *
     * @param idNo 身份证号
     * @return true有实名账户 false无实名账户
     */
    Boolean hasUserAuthorized(String idNo);

    /**
     * 创建实名账户
     *
     * @param parameters 请求参数
     * @return 成功返回success 失败返回fail
     */
    String createUserAuthorized(Map<String,String> parameters);

    /**
     * 通过userId获取实名账户表的id
     *
     * @param userId userId
     * @return userAuthorized的id
     */
    Long getUserAuthorizedId(Long userId);
}
