package cn.quantgroup.xyqb.service.user;

import cn.quantgroup.xyqb.controller.internal.user.resp.UserFullResp;
import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.UserInfo;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * Created by Miraculous on 15/7/5.
 */
public interface IUserService {

    User findByPhoneWithCache(String phone);

    User findByUuidWithCache(String uuid);

    boolean exist(String phoneNo);

    boolean resetPassword(String phoneNo, String password);

    User findByPhoneInDb(String phone);

    User findByUuidInDb(String uuid);

    /**
     * 根据手机号或身份证号查询用户UUID
     *
     * @param phoneNo - 手机号
     * @param idNo    - 身份证号
     * @return user表的uuid
     */
    String findUuid(String phoneNo, String idNo);

    Map<Long, String> findPhoneByIdsInDb(List<Long> userIds);

    User saveUser(User user);

    User findById(Long userId);

    List<User> findByPhones(List<String> phones);

    List<User> findRegisterUserByTime(String beginTime, String endTime);

    /**
     * 禁用用户
     *
     * @param phoneNo 电话号码
     */
    int forbiddenUser(Boolean enable, String phoneNo);

    List<UserInfo> findUserInfosByPhones(List<String> phones);

    User findByMd5(Integer type, String md5Value);

    /**
     * 修改手机号码.
     *
     * @param oldPhoneNo 旧手机号
     * @param newPhoneNo 新手机号
     * @return 返回用户信息
     */
    User modifyPhoneNo(String oldPhoneNo, String newPhoneNo);

    /**
     * 删除这个用户相关缓存
     *
     * @param uuid    根据 uuid
     * @param phoneNo 根据手机号
     */
    void userCacheEvict(String uuid, String phoneNo);

    JsonResult loginFast(Long channelId, String appChannel, Long createdFrom, Long btRegisterChannelId,
                         String dimension, String clickId, HttpServletRequest request, Merchant merchant,
                         String phoneNo);

    /**
     * 查询用户全量信息
     *
     * @param userId 用户id
     * @return
     */
    UserFullResp findUserFullSearchByUserId(Long userId);

    /**
     * 按照userid 或者 uuid 批量查询
     * @param vals
     * @param type
     * @return
     */
    List<User> findByUuidsOrUserIds(List<String> vals,Integer type);
}
