package cn.quantgroup.xyqb.config.captcha;

import cn.quantgroup.xyqb.thirdparty.jcaptcha.AbstractManageableImageCaptchaService;
import com.octo.captcha.engine.CaptchaEngine;
import com.octo.captcha.service.captchastore.CaptchaStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * 类名称：CaptchaConfig
 * 类描述：
 *
 * @author 李宁
 * @version 1.0.0
 * 创建时间：15/11/17 12:04
 * 修改人：
 * 修改时间：15/11/17 12:04
 * 修改备注：
 */
@Configuration
public class CaptchaConfig {

    @Bean
    public CaptchaEngine initCaptchaEngine() {
        return new CustomCaptchaEngine();
    }

    @Bean
    @Autowired
    @Qualifier("stringRedisTemplate")
    public CaptchaStore initStringCaptchaStore(RedisTemplate<String, String> stringRedisTemplate) {
        return new RedisCaptchaStore(stringRedisTemplate);
    }


    @Bean(name = "customCaptchaService")
    @Autowired
    public AbstractManageableImageCaptchaService initCaptchaService(CaptchaStore captchaStore, CaptchaEngine captchaEngine) {
        return new CustomCaptchaService(captchaStore, captchaEngine);
    }

}
