package cn.quantgroup.xyqb.controller.middleoffice.common;

import cn.quantgroup.xyqb.util.ApplicationContextHolder;

import java.util.HashMap;
import java.util.Map;

public class VerifyStrategyFactory {

    private static final Map<VerifyTypeEnum, IVerifyStrategy> strategiesMap = new HashMap<>();

    static {
        //cache
        Map<String, IVerifyStrategy> beansOfType = ApplicationContextHolder.getBeansOfType(IVerifyStrategy.class);
        beansOfType.values().forEach(strategy -> strategiesMap.put(strategy.strategyName(), strategy));
    }

    public static IVerifyStrategy get(VerifyTypeEnum verifyTypeEnum) {
        return strategiesMap.get(verifyTypeEnum);
    }
}
