package cn.quantgroup.xyqb.entity;


import cn.quantgroup.user.enums.MaritalStatus;
import cn.quantgroup.xyqb.util.ValidationUtil;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

@Data
@Entity
@Table(name = "user_spouse", uniqueConstraints = @UniqueConstraint(columnNames = "user_id"))
@Getter
@Setter
@ToString
@NoArgsConstructor
public class UserSpouse implements Serializable {
  private static final long serialVersionUID = -1L;

  @Id
  @Column(name = "id")
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private Long id;

  @Column(name = "user_id")
  private Long userId;

  @Column(name = "spouse_phone")
  private String spousePhone;

  @Column(name = "spouse_name")
  private String spouseName;

  @Column(name = "created_at")
  private Timestamp createdAt;

  @Column(name = "updated_at")
  private Timestamp updateAt;

  @Column(name = "status")
  private MaritalStatus status;

  public UserSpouse(Long userId) {
    this.userId = userId;
  }

  /**
   * 数据合法性校验
   * @return
   */
  public boolean valid(){
    return (ValidationUtil.validatePhoneNo(this.spousePhone) && ValidationUtil.validateChinese(this.spouseName));
  }
}
