package cn.quantgroup.xyqb.controller.modifyphoneno.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * Date: 2019/11/4
 * Time: 上午11:53
 *
 * @author: yangrui
 */
@Data
public class AuditReq {
    @NotNull(message = "id不能为空")
    private Long id;
    @ApiModelProperty("申请状态 0处理中; 1修改完成; 2不允许修改;")
    @NotNull(message = "申请状态不能为空")
    @Range(min = 0, max = 2, message = "申请状态不合法。")
    private Integer applyStatus;
    @ApiModelProperty("申请状态补充原因")
    private String applyStatusReason;
}
