package cn.quantgroup.xyqb.service.security.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.exception.UserNotExistException;
import cn.quantgroup.xyqb.model.AuthenticationUserDetail;
import cn.quantgroup.xyqb.service.user.IUserService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Service;

@Service
public class UserDetailsByUuidService implements AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> {

    @Autowired
    private IUserService userService;

    @Override
    public UserDetails loadUserDetails(PreAuthenticatedAuthenticationToken token) throws UsernameNotFoundException {
        String uuid = (String) token.getPrincipal();
        if (StringUtils.isEmpty(uuid) || uuid.length() <= 10) {
            throw new UserNotExistException(String.format("用户未找到, uuid:%s", uuid));
        }
        User user = userService.findByUuid(uuid);

        if (user == null) {
            throw new UserNotExistException(String.format("用户未找到, uuid:%s", uuid));
        }

        return new AuthenticationUserDetail(user);
    }
}
