package cn.quantgroup.xyqb.entity.baseEntity;


import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EntityListeners;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@EntityListeners({AuditingEntityListener.class})
@MappedSuperclass
public abstract class OptimisticEntity implements PersistentKey, BasicEntity {
    @NotNull
    @LastModifiedBy
    @Column(
            name = "MODIFIED_BY",
            nullable = false,
            updatable = false,
            length = 36
    )
    private String modifiedBy;
    @NotNull
    @LastModifiedDate
    @Column(
            name = "MODIFIED_DATE",
            nullable = false
    )
    private Date modifiedDate;
    @NotNull
    @CreatedBy
    @Column(
            name = "CREATED_BY",
            nullable = false,
            updatable = false,
            length = 36
    )
    public String createdBy;
    @NotNull
    @CreatedDate
    @Column(
            name = "CREATED_DATE",
            nullable = false,
            updatable = false
    )
    public Date createdDate;
    @NotNull
    @Version
    @Column(
            name = "MODIFIED_NO",
            nullable = false
    )
    private Integer modifiedNo = 1;

    public OptimisticEntity() {
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Integer getModifiedNo() {
        return this.modifiedNo;
    }

    public void setModifiedNo(Integer modifiedNo) {
        this.modifiedNo = modifiedNo;
    }
}

