package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.tech.db.DSType;
import cn.quantgroup.tech.db.TargetDataSource;
import cn.quantgroup.xyqb.entity.CustomerInfoEntity;
import cn.quantgroup.xyqb.repository.ICustomerInfoRepository;
import cn.quantgroup.xyqb.service.user.ICustomerInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by 11 on 2016/12/29.
 */
@Slf4j
@Service
public class CustomerInfoServiceImpl implements ICustomerInfoService {
    @Autowired
    private ICustomerInfoRepository customerInfoRepository;

    @Override
    @TargetDataSource(type = DSType.SLAVE)//查询从库
    public CustomerInfoEntity findSlaveByCustomerId(Long customerId) {
        CustomerInfoEntity customerInfo = customerInfoRepository.findByCustomerId(customerId);
        return customerInfo;
    }

    @Override
    @TargetDataSource(type = DSType.SLAVE)//查询从库
    public CustomerInfoEntity findSlaveByOpenId(String openId, String institutionId, String productId) {
        CustomerInfoEntity customerInfo = customerInfoRepository.findByInstitutionIdAndProductIdAndSourceOpenId(institutionId, productId, openId);
        return customerInfo;
    }
}
