package cn.quantgroup.xyqb.controller.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

/**
 * common page
 * <p>
 * Date: 2019/11/5
 * Time: 下午4:06
 *
 * @author: yangrui
 */
@Data
public class Page {
    /**
     * page
     */
    @ApiModelProperty("one-based page index")
    private Integer page = 1;

    /**
     * size
     */
    @ApiModelProperty("the size of the page to be returned")
    @Range(min = 1, max = 1000, message = "size参数必须在1到1000之间")
    private Integer size = 30;
}
