package cn.quantgroup.xyqb.controller.req.v2;

import lombok.Data;

import javax.validation.constraints.Size;

@Data
public class SMSReq {
    /**
     * 0:是短信，1是语音，默认值是0
     */
    private Integer type = 0;

    /**
     * 手机号码，必填
     */
    @Size(min = 11,max = 18)
    private String phoneNo;

    /**
     * 场景类型，0：是普通默认短信，1是登录，2是重置密码
     */
    private Integer sceneType = 0;

    /**
     * 指定验证码长度，可选，4-10位
     */
    private Integer codeLength;

    /**
     * 指定模版参数，可选，需要自己指定模版时选用
     */
    private String smsMerchant;

}
