package cn.quantgroup.xyqb.service.session.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.function.OneArgFunction;
import cn.quantgroup.xyqb.model.LoginProperties;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.session.SessionValue;
import cn.quantgroup.xyqb.service.session.ISessionService;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 *
 * Created by 11 on 2016/12/28.
 */
@Service
public class SessionServiceImpl implements ISessionService{

    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> stringRedisTemplate;

    @Override
    public SessionStruct createSessionAndPersistInCache(User user, LoginProperties properties) {
        return createSessionAndPersist(user, properties);
    }

    @Override
    public SessionStruct createSessionAndPersist(User user, LoginProperties properties) {
        SessionStruct sessionStruct;
        //获取sessionid
        String sessionId = findSessionIdByUserIdLoginProperties(user.getId(), properties);
        if (StringUtils.length(sessionId) == 36) {
            sessionStruct = findSessionBySessionId(sessionId);
            if (sessionStruct == null) {
                sessionStruct = newSession(user, properties);
                persistSession(sessionStruct.getSid(), sessionStruct.getValues());
            }
        } else {
            sessionStruct = newSession(user, properties);
            persistSession(sessionStruct.getSid(), sessionStruct.getValues());
        }
        return sessionStruct;
    }

    @Override
    public String findSessionIdByUserIdLoginProperties(Long userId, LoginProperties properties) {
        return stringRedisTemplate.opsForValue().get(generateLoginPropertiesKey(userId, properties));
    }

    private String generateLoginPropertiesKey(Long userId, LoginProperties properties) {
        if ("baitiao".equals(properties.getMerchantName())) {
            return Constants.Session.USER_SESSION_ID_CACHE + ":" + String.valueOf(userId) + ":" + properties.getMerchantName() + ":" + properties.getCreatedFrom();
        } else {
            return Constants.Session.USER_SESSION_ID_CACHE + ":" + String.valueOf(userId) + ":" + properties.getMerchantName();
        }
    }

    @Override
    public String findSessionValueBySessionId(String sessionId){
        String result = stringRedisTemplate.opsForValue().get(Constants.Session.USER_SESSION_CACHE + sessionId);
        return StringUtils.defaultString(result, "");
    }

    @Override
    public SessionStruct newSession(User user, LoginProperties loginProperties){
        Timestamp now = new Timestamp(System.currentTimeMillis());
        SessionStruct sessionStruct = new SessionStruct();
        SessionValue sessionValue = new SessionValue();
        sessionStruct.setSid(UUID.randomUUID().toString());
        sessionValue.setCreatedAt(now);
        sessionValue.setLastAccessTime(now);
        sessionValue.setUser(user);
        sessionValue.setLoginProperties(loginProperties);
        Map<String, String> values = new HashMap<>();
        sessionValue.setValues(values);
        sessionStruct.setValues(sessionValue);
        return sessionStruct;
    }

    @Override
    public void persistSession(String token, SessionValue sessionValue) {
        Timestamp current = new Timestamp(System.currentTimeMillis());
        sessionValue.setLastAccessTime(current);
        String json = JSON.toJSONString(sessionValue);
        stringRedisTemplate.opsForValue().set(Constants.Session.USER_SESSION_CACHE + token, json,
                Constants.Session.ONE_DAY, TimeUnit.SECONDS);
        String key = generateLoginPropertiesKey(sessionValue.getUser().getId(), sessionValue.getLoginProperties());
        stringRedisTemplate.opsForValue().set(key, token, Constants.Session.ONE_DAY, TimeUnit.SECONDS);
    }

    @Override
    public SessionStruct findSessionBySessionId(String sessionId) {
        String sessionValue = findSessionValueBySessionId(sessionId);
        if(StringUtils.isEmpty(sessionValue)) {
            return null;
        }
        try {
            SessionValue value = JSON.parseObject(sessionValue, SessionValue.class);
            if (null == value) {
                return null;
            }
            SessionStruct struct = new SessionStruct();
            struct.setSid(sessionId);
            struct.setValues(value);
            return struct;
        } catch (Exception ex) {
            return null;
        }

    }


}
