package cn.quantgroup.xyqb.service.event;

import cn.qg.ec.model.base.BusinessEventBaseInfo;
import cn.qg.ec.model.user.UserLoginRegEvent;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.security.AssentHeader;
import cn.quantgroup.xyqb.model.AuthBean;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.risk.uereventcollecting.UserEventCollectingUtil;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.encrypt.Md5Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;

/**
 * Created by Administrator on 2021/6/30 0030.
 */
@Service
public class KinesisService {

    private static final Logger logger = LoggerFactory.getLogger(KinesisService.class);

    @Resource
    private IUserService iUserService;

    public void send(UserLoginRegEvent.SubEventType type, AssentHeader header, Object loginResult) {
        String phoneNumber = header.getPhoneNumber();
        if (StringUtils.isEmpty(phoneNumber)) {
            return;
        }
        long nanoTime = System.nanoTime();
        try {
            logger.info(">>>> KNS-PRDR-B -- {}; .TP={}; .PN={}; .DCID={}; .CONT={}", nanoTime, type, header.getPhoneNumber(), header.getDeviceId(), header);
            UserLoginRegEvent.UserLoginRegEventBuilder builder = UserLoginRegEvent.builder();
            builder.maskPhoneNo(phoneNumber);
            builder.hashPhoneNo(Md5Util.build(Md5Util.build(phoneNumber)));
            builder.subEventType(type);
            BusinessEventBaseInfo.BusinessEventBaseInfoBuilder baseInfoBuilder
                    = BusinessEventBaseInfo.builder();
            if (null != loginResult) {
                if (loginResult instanceof JsonResult) {
                    JsonResult jsonResult = ((JsonResult) loginResult);
                    if (jsonResult.isSuccess()) {
                        Object data = jsonResult.getData();
                        if (data instanceof AuthBean) {
                            String uuid = ((AuthBean) data).getUuid();
                            User user = iUserService.findByUuidWithCache(uuid);
                            baseInfoBuilder.userUuid(uuid);
                            baseInfoBuilder.channel(String.valueOf(user.getRegisteredFrom()));
                        } else {
                            return;
                        }
                    } else {
                        return;
                    }
                }
            }
            baseInfoBuilder.deviceId(header.getDeviceId());
            baseInfoBuilder.ip(header.getRemoteAddress());
            baseInfoBuilder.deviceType(header.getDevice().getCode());
            builder.businessEventBaseInfo(baseInfoBuilder.build());
            UserEventCollectingUtil.addEvent(builder.build());
            logger.info("++ KNS-PRDR -- {}; .CONT={}", nanoTime, builder.toString());
        } catch (Exception e) {
            logger.error("!! KNS-PRDR-E -- " + nanoTime + "; .CONT=" + e.getMessage(), e);
            throw e;
        } finally {
            logger.info("<<<< KNS-PRDR-F -- {}", nanoTime);
        }
    }
}
