package cn.quantgroup.xyqb.entity;

import cn.quantgroup.motan.retbean.XUserDetail;
import cn.quantgroup.xyqb.model.Gender;
import cn.quantgroup.xyqb.model.IdType;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import java.io.Serializable;
import java.util.Optional;

/**
 * Created by FrankChow on 15/7/8.
 */
@Getter
@Setter
@ToString
@Entity
@Table(name = "user_detail",
       uniqueConstraints = @UniqueConstraint(columnNames = "user_id"))
public class UserDetail extends BaseEntity implements Serializable {

    private static final long serialVersionUID = -1L;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "phone_no")
    private String phoneNo;

    @Column(name = "name")
    private String name;

    //身份证验真 0 未认证 1认证
    @Column(name = "is_authenticated")
    private Boolean isAuthenticated = false;

    //0 未知 1 女 2 男
    @Column(name = "gender")
    private Gender gender;

    @Column(name = "email")
    private String email;

    @Column(name = "qq")
    private String qq;

    public XUserDetail toXUserDetail() {
        XUserDetail xUserDetail = new XUserDetail();
        xUserDetail.setId(this.getId());
        xUserDetail.setUserId(this.getUserId());
        xUserDetail.setPhoneNo(this.getPhoneNo());
        xUserDetail.setName(this.getName());
        if (this.getGender() != null) {
            xUserDetail.setGender(cn.quantgroup.motan.enums.Gender.valueOf(Optional.ofNullable(this.getGender())
                                                                                   .orElse(Gender.UNKNOWN)
                                                                                   .name()));
        }
        xUserDetail.setEmail(this.getEmail());
        xUserDetail.setQq(this.getQq());
        xUserDetail.setId(this.getId());
        xUserDetail.setCreatedAt(this.getCreatedAt());
        xUserDetail.setUpdatedAt(this.getUpdatedAt());
        xUserDetail.setIsAuthenticated(this.getIsAuthenticated());
        return xUserDetail;
    }

}
