package cn.quantgroup.xyqb.controller.middleoffice.applet;

import cn.quantgroup.xyqb.controller.middleoffice.common.VerifyTypeEnum;
import cn.quantgroup.xyqb.controller.middleoffice.login.ILoginModule;
import cn.quantgroup.xyqb.controller.middleoffice.login.LoginVo;
import cn.quantgroup.xyqb.entity.middleoffice.AppletParamEntry;
import cn.quantgroup.xyqb.exception.DataException;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.middleoffice.applet.IAppletService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/5/27 17:24
 * @description：小程序控制器
 * @modified By：
 * @version: 1.0
 */
@Slf4j
@RestController
@RequestMapping("/middle_office/applet")
public class AppletController {
    //先这么干 多了的话建表去存
    private static final List<String> appNames = Lists.newArrayList(
            "luckii", "xyqb", "wuxi");
    private final IAppletService iAppletService;
    private ILoginModule loginModule;

    @Autowired
    AppletController(IAppletService iAppletService,
                     ILoginModule loginModule
    ) {
        this.iAppletService = iAppletService;
        this.loginModule = loginModule;
    }

    /**
     * @return
     */
    @PostMapping("/relevance")
    public JsonResult relevance(@Validated @RequestBody AppletParamEntry appletParamEntry) {
        if (!appNames.contains(appletParamEntry.getAppName())) {
            throw new DataException("appName不合法");
        }
        Long userId = iAppletService.relevance(appletParamEntry);

        LoginVo loginVo = loginModule.loginByUserId(appletParamEntry.getChannelId(),
                appletParamEntry.getUtmSource(), userId);

        return JsonResult
                .buildSuccessResultGeneric(loginVo);
    }

    /**
     * @return
     */
    @PostMapping("/login")
    public JsonResult login(String appName, String openId, String utmSource) {
        if (!appNames.contains(appName)) {
            throw new DataException("appName不合法");
        }

        LoginVo login = iAppletService.login(appName, openId, utmSource);
        return JsonResult.buildSuccessResultGeneric(login);
    }
}
