package cn.quantgroup.xyqb.controller.middleoffice.common;

import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

import java.util.HashMap;
import java.util.Map;

public class VerifyStrategyFactory {

    private static final Map<VerifyTypeEnum, IVerifyStrategy> strategiesMap = new HashMap<>();

    static {
        //cache
        WebApplicationContext context = ContextLoader.getCurrentWebApplicationContext();
        Map<String, IVerifyStrategy> beansOfType = context.getBeansOfType(IVerifyStrategy.class);
        beansOfType.values().forEach(strategy -> strategiesMap.put(strategy.strategyName(), strategy));
    }

    public static IVerifyStrategy get(VerifyTypeEnum verifyTypeEnum) {
        return strategiesMap.get(verifyTypeEnum);
    }

}
