package cn.quantgroup.xyqb.controller.external.user;

import cn.quantgroup.xyqb.entity.WebChatUserInfo;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.webchat.AccessTokenResponse;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.user.IUserService;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

/**
 * Created by 11 on 2017/1/17.
 */
@RestController
@RequestMapping("/webchat")
public class WebChatController {

    public static final String TOKEN = "5YihkluEo5QuWAWpFwzvA";

    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(WebChatController.class);

    @Autowired
    private IHttpService httpService;
    @Autowired
    private IUserService userService;
    public String access_token_url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=wxcdf6077af8127559&secret=16eaec16084d0d9c52d4114f359cc72c&code=%s&grant_type=authorization_code";
    public String access_userinfo_url = "https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=zh_CN";


    /**
     * 开发者资质认证,有必要吗?
     * @param request
     * @return
     */
    @RequestMapping("/checkValid")
    public String valid(HttpServletRequest request) {
        String echoStr = request.getParameter("echostr");
        if(checkSignature(request)){
            return echoStr;
        }
        return "";
    }

    /**
     * 微信登录
     * @param name 姓名
     * @param idNo 身份证号
     * @param phoneNo 手机号
     * @param registerFrom ${registerFrom}
     * @param channelId ${channelId}
     * @param appChannel ${appChanel}
     * @param key "xyqb"
     * @return
     */
    public JsonResult webChatLogin(String name, String idNo, String phoneNo, String registerFrom,
                                   String channelId, String appChannel, String key){
        if(StringUtils.isBlank(name) || StringUtils.isBlank(idNo) || StringUtils.isBlank(phoneNo)){
            return JsonResult.buildErrorStateResult("请填写完整的用户信息.", null);
        }
        if(StringUtils.isBlank(key)){
            return JsonResult.buildErrorStateResult("无效的商户信息.", null);
        }
        return null;
    }

    public static void main(String[] args) {
        String test = " ";
        System.out.println(StringUtils.isEmpty(test));
        System.out.println(StringUtils.isBlank(test));
    }

    /**
     * 验签：步骤
     *      1.获取signature, timestamp, nonce三个参数
     *      2.用timestamp, nonce, token三个参数做字符升序排列
     *      3.将排列好的字符串进行sha1加密,和signature参数做比较
     *      4.相等返回true,否则返回false
     * @param request
     * @return
     */
    public boolean checkSignature(HttpServletRequest request) {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String token = TOKEN;
        String[] arrs = new String[]{token, timestamp, nonce};
        Arrays.sort(arrs);
        String joinStr = splitArray(arrs);
        joinStr = sha1(joinStr);
        return joinStr.equals(signature);
    }

    /**
     * sha1加密算法,
     * @param decript
     * @return 返回40位16进制字符串
     */
    public String sha1(String decript) {
        try {
            MessageDigest digest = java.security.MessageDigest
                    .getInstance("SHA-1");
            digest.update(decript.getBytes());
            byte messageDigest[] = digest.digest();
            StringBuffer hexString = new StringBuffer();
            // 字节数组转换为十六进制数
            for (int i = 0; i < messageDigest.length; i++) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();

        } catch (NoSuchAlgorithmException e) {
            LOGGER.error("未找到sha1算法." + e.getMessage());
        }
        return "";
    }

    /**
     * 数组分割为字符串
     * @param arr
     * @return
     */
    private String splitArray(String[] arr) {
        StringBuilder builder = new StringBuilder();
        for(String str : arr){
            builder.append(str);
        }
        return builder.toString();
    }

    /**
     * 通过redirect_url获取code
     * @param request
     * @return
     */
    @RequestMapping("/receiveCode")
    public String receiveCode(HttpServletRequest request) {
        String code = request.getParameter("code");
        receiveAccessToken(code);
        return null;
    }

    /**
     * 拿到access_token,openId,获取用户信息,入库
     * @param code
     * @return
     */
    private JsonResult receiveAccessToken(String code) {
        String finalAccessTokenUrl = String.format(access_token_url, code);
        String response = httpService.get(finalAccessTokenUrl);
        AccessTokenResponse accessTokenResponse = null;
        try {
            accessTokenResponse = JSON.parseObject(response, AccessTokenResponse.class);
        } catch (Exception e){
            LOGGER.error("获取access_token出错{}:", e);
            return JsonResult.buildErrorStateResult("获取access_token出错", null);
        }
        //从AccessTokenResponse中获取access_token, openid
        String access_token = accessTokenResponse.getAccessToken();
        String openId = accessTokenResponse.getOpenId();
        String finalUserInfoUrl = String.format(access_userinfo_url, access_token, openId);
        //拉取用户信息
        String userInfo = httpService.get(finalUserInfoUrl);
        saveWebChatUserInfo(userInfo);
        return JsonResult.buildSuccessResult("success", null);
    }

    /**
     * 保存微信用户信息
     * @param userInfo
     */
    private void saveWebChatUserInfo(String userInfo) {
        WebChatUserInfo webChatUserInfo = JSON.parseObject(userInfo, WebChatUserInfo.class);
        userService.saveWebChatUserInfo(webChatUserInfo);
    }
}
