package cn.quantgroup.xyqb.util;

import java.util.regex.Pattern;

/**
 * 过滤emoji表情
 * @author renwc
 * @date 2018-02-26
 */
public class EmojiUtil {
  public static final String BYTE_4_REPLACE_TEMPLATE = "*";
  /**
   * Emoji表情
   * 1-3字节
   * [©-㊙]
   */
  private static final Pattern EMOJI_USC_123 = Pattern.compile("[©-㊙]|\ufe0f");
  /**
   * Emoji表情
   * 4字节
   * [🀄-🧦]
   */
  private static final Pattern EMOJI_USC_4 = Pattern.compile("[\uD83C\uDC04-\uD83E\uDDE6]");
  /**
   * Emoji表情
   * 1-4字节
   * [©-㊙]|[🀄-🧦]
   */
  private static final Pattern EMOJI_USC_1234 = Pattern.compile("[\uD83C\uDC04-\uD83E\uDDE6]|[©-㊙]|\ufe0f");

  /**
   * 替换所有Emoji表情字符
   * @param text
   * @return
   */
  public static String filterUnicode1234(String text) {
    return text == null || text.trim().isEmpty() ? text : EMOJI_USC_1234.matcher(text).replaceAll("");
  }

  /**
   * 替换所有Emoji表情字符
   * 条件：UTF-8编码时4字节的
   * @param text
   * @return
   */
  public static String filterUnicode4(String text) {
    return text == null || text.trim().isEmpty() ? text : EMOJI_USC_4.matcher(text).replaceAll(BYTE_4_REPLACE_TEMPLATE);
  }

}
