package cn.quantgroup.xyqb.controller.external.user;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.api.IUserApiService;
import cn.quantgroup.xyqb.service.user.IUserService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by FrankChow on 15/12/16.
 */
@RestController
@RequestMapping("/api")
public class UserApiController {

  private static final Logger LOGGER = LoggerFactory.getLogger(UserApiController.class);

  @Autowired
  private IUserApiService userApiService;
  @Autowired
  private IUserService userService;

  @RequestMapping("/user/check")
  public JsonResult userImportCheck(String phoneNo, String registerFrom) {
    if ("244".equals(registerFrom)) {
      LOGGER.info("[user_import_check]用户导入检查拒绝。phoneNo=[{}], registerFrom=[{}]", phoneNo, registerFrom);
      return JsonResult.buildErrorStateResult("用户导入检查拒绝", false);
    }
    if (StringUtils.isEmpty(phoneNo) || StringUtils.isEmpty(registerFrom)) {
      LOGGER.error("[user_import_check]检查传入的参数，参数不全。phoneNo=[{}], registerFrom=[{}]", phoneNo, registerFrom);
      return JsonResult.buildErrorStateResult("检查传入的参数，参数不全。", null);
    }
    boolean checkPassed = userApiService.userImportCheck(phoneNo);
    if (checkPassed) {
      LOGGER.info("[user_import_check]用户可以导入。phoneNo=[{}], registerFrom=[{}]", phoneNo, registerFrom);
      return JsonResult.buildSuccessResult("用户可以导入", checkPassed);
    }
    LOGGER.info("[user_import_check]用户导入检查拒绝。phoneNo=[{}], registerFrom=[{}]", phoneNo, registerFrom);
    return JsonResult.buildErrorStateResult("用户导入检查拒绝", checkPassed);
  }

  @RequestMapping("/user/is_passwd_set")
  public JsonResult isPasswordSet(String key, String phoneNo) {
    if (!"abc1234".equals(key) || StringUtils.isEmpty(phoneNo)) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    User user = userService.findByPhoneWithCache(phoneNo);
    if (null == user) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    if (StringUtils.length(user.getPassword()) == 32) {
      return JsonResult.buildSuccessResult(null, null);
    }
    return JsonResult.buildErrorStateResult(null, null, 2L);
  }

}
