package cn.quantgroup.xyqb.controller.modifyphoneno.req;

import cn.quantgroup.xyqb.entity.enums.Reason;
import cn.quantgroup.xyqb.util.ValidationUtil;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

@Data
public class ModifyPhoneRecord implements Serializable {

//    @NotNull(message = "用户ID不能为空")
    private Long userId;

    @NotBlank(message = "原手机号不能为空")
    @Pattern(regexp = ValidationUtil.phoneRegExp, message = "原手机号码格式错误")
    private String prevPhoneNo;

    @NotBlank(message = "新手机号不能为空")
    @Pattern(regexp = ValidationUtil.phoneRegExp, message = "新手机号码格式错误")
    private String curPhoneNo;

    @NotNull(message = "修改原因不能为空")
    private Reason reason;

    @NotBlank(message = "操作人不能为空")
    private String operator;

//    @NotBlank(message = "备注不能为空")
    private String remark;

}
