package cn.quantgroup.xyqb.service;

import static cn.quantgroup.xyqb.security.SecurityConstant.DEFAULT_DEVICE_ID;

import cn.quantgroup.xyqb.entity.enums.Device;
import cn.quantgroup.xyqb.model.LoginRefuseResult;
import cn.quantgroup.xyqb.risk.repository.LoginInfoRepository;
import cn.quantgroup.xyqb.risk.repository.WhiteListRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * Created by Administrator on 2021/7/1 0001.
 */
@Service
public class LoginInfoService {

    private static final Logger logger = LoggerFactory.getLogger(LoginInfoService.class);

    @Autowired
    private LoginInfoRepository loginInfoRepository;

    @Autowired
    private WhiteListRepository whiteListRepository;

    private LoginRefuseResult verification(String deviceId, String phone, Device device) {

            /**
             * 默认code不需要
             */
            if (DEFAULT_DEVICE_ID.equals(deviceId)) {
                return LoginRefuseResult.builder()
                        .isPass(Boolean.TRUE).build();
            }
            /**
             * 如果没传手机也放过吧
             */
            if (StringUtils.isEmpty(phone)) {
                return LoginRefuseResult.builder()
                        .isPass(Boolean.TRUE).build();
            }

        //        try {
//            /**
//             * 阈值
//             */
//            Long threshold = DEVICE_REFUSE_STRATEGY.get(device);
//
//            if (null == threshold) {
//                log.warn("非安卓或者IOS设备登录没有策略就放过phone:{},device:{}", phone, device);
//                return LoginRefuseResult.builder()
//                        .isPass(Boolean.TRUE).build();
//            }
//
//            Long deviceNum = loginInfoRepository.countByDeviceId(deviceId, phone);
//
//            if (DEVICE_REFUSE_COUNT.compareTo(deviceNum) <= 0) {
//                if (!isWhite(deviceId, KeyType.DEVICEID)) {
//                    log.warn("此设备登录命中拒绝策略deviceId:{}超过{}个拒绝登录", deviceId, deviceNum);
//                    return LoginRefuseResult.builder()
//                            .isPass(Boolean.FALSE)
//                            .rule(RISK_STRATEGY[0])
//                            .threshold(DEVICE_REFUSE_COUNT.intValue())
//                            .value(deviceNum.intValue())
//                            .build();
//                }
//
//            }
//
//            CountDevice countDevice = loginInfoRepository.countByPhoneAndDevice(phone, device.ordinal(), deviceId);
//
//            if (null == countDevice) {
//                return LoginRefuseResult.builder()
//                        .isPass(Boolean.TRUE)
//                        .build();
//            }
//            /**
//             * 实际的数量
//             */
//            Long val = countDevice.getNum();
//
//            if (threshold.compareTo(val) <= 0) {
//                if (!isWhite(phone, KeyType.PHONE)) {
//                    log.warn("此账户登录命中拒绝策略并且没有白名单phone:{},device:{}", phone, device);
//                    return LoginRefuseResult.builder()
//                            .isPass(Boolean.FALSE)
//                            .rule(RISK_STRATEGY[1])
//                            .threshold(threshold.intValue())
//                            .value(Long.valueOf(val).intValue())
//                            .build();
//                }
//                log.warn("此账户登录命中拒绝策略存在白名单phone:{}", phone);
//            }
//        } catch (Exception e) {
//            log.error("用户登录策略校验异常了", e);
//        }
//        return LoginRefuseResult.builder()
//                .isPass(Boolean.TRUE)
//                .build();

            return null;
    }
}
