package cn.quantgroup.xyqb.controller.external.user;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.IdCardInfo;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.UserModel;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.ValidationUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;
import java.util.Objects;

/**
 * 同步用户数据，第三方模块访问时
 * Created by Miraculous on 15/12/29.
 */
@RestController
@RequestMapping("/api/sync")
public class SyncUserController {
  private static final Logger LOGGER = LoggerFactory.getLogger(SyncUserController.class);

  @Autowired
  private IUserService userService;
  @Autowired
  private IUserDetailService userDetailService;
  @Autowired
  private IIdCardService idCardService;


  @Autowired
  @Qualifier("stringRedisTemplate")
  private RedisTemplate<String, String> stringRedisTemplate;

  public SyncUserController() {
  }

  @RequestMapping("/user")
  public JsonResult fetchUser(String key, String phoneNo) {
    if (StringUtils.isEmpty(key) || !"abc1234".equals(key)) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    if (StringUtils.isEmpty(phoneNo)) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    User user = userService.findByPhoneInDb(phoneNo);
    if (null == user) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    UserDetail detail = userDetailService.findByUserId(user.getId());
    if (null == detail) {
      // FIXME: 16/4/15 前期不对身份证强制要求.后期对修改
//            return JsonResult.buildErrorStateResult(null, null);
    }
    UserModel userModel = new UserModel(user, detail);
    return JsonResult.buildSuccessResult(null, userModel);
  }

  @RequestMapping("/save_detail")
  public JsonResult saveUserDetail(String key, UserDetail userDetail) {
    if (StringUtils.isEmpty(key) || !"abc1234".equals(key) || Objects.isNull(userDetail) || StringUtils.isBlank(userDetail.getPhoneNo())) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    if (!ValidationUtil.validateChinese(userDetail.getName())) {
      return JsonResult.buildErrorStateResult("姓名错误", null);
    }
    IdCardInfo info = null;
    try {
      info = idCardService.getIdCardInfo(userDetail.getIdNo());
    } catch (ParseException ex) {
      LOGGER.error("身份证号错误, idNo: {}", userDetail.getIdNo());
      return JsonResult.buildErrorStateResult("身份证号码错误", null);
    }
    if (Objects.isNull(info) || !info.isValid()) {
      return JsonResult.buildErrorStateResult("身份证号码错误", null);
    }
    String phoneNo = userDetail.getPhoneNo();
    User user = userService.findByPhoneWithCache(phoneNo);
    if (null == user) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    userDetail.setId(null);
    userDetail.setUserId(user.getId());
    userDetailService.saveUserDetail(userDetail);
    return JsonResult.buildSuccessResult(null, null);
  }

  @RequestMapping("/user_uuid")
  public JsonResult fetchUserByUuid(String key, String uuid) {
    if (StringUtils.isEmpty(key) || !"abc1234".equals(key)) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    if (StringUtils.isEmpty(uuid)) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    User user = userService.findByUuidWithCache(uuid);
    if (null == user) {
      return JsonResult.buildErrorStateResult(null, null);
    }
    UserDetail detail = userDetailService.findByUserId(user.getId());
    if (null == detail) {
      // FIXME: 16/4/15 前期不对身份证强制要求.后期对修改
//            return JsonResult.buildErrorStateResult(null, null);
    }
    UserModel userModel = new UserModel(user, detail);
    return JsonResult.buildSuccessResult(null, userModel);
  }
}
