package cn.quantgroup.xyqb.controller.internal.token;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.model.JsonResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * 发放单次令牌
 *
 * @author 任文超
 * @version 1.0.0
 * @since 2017-10-31
 */
@RestController
@RequestMapping("/token")
public class TokenOnceController implements IBaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(TokenOnceController.class);
  private static final Long ONE_HOUR = 1 * 60 * 60L;

  @Autowired
  @Qualifier("stringRedisTemplate")
  private RedisTemplate<String, String> redisTemplate;

  /**
   * 向指定用户账号（手机号）发放一枚TokenOnce
   * TokenOnce用法：其首部行必须包含形如【TokenOnce MTM0NjEwNjc2NjI6NmFjMDY2NWItZTE5Yy00MzkyLWEyNDQtN2I2MTY5MDgzM2Y1】的UTF-8编码的Base64加密参数
   * 例如：Base64.getEncoder().encodeToString("13461067662:6ac0665b-e19c-4392-a244-7b61690833f5".getBytes(Charset.forName("UTF-8")));
   *
   * @param phoneNo 用户账号（手机号）
   * @return 单次令牌
   */
  @RequestMapping(value = "/once")
  public JsonResult newTokenOnce(HttpServletRequest request, @ModelAttribute("phoneNo") String phoneNo) {
    if (StringUtils.isBlank(phoneNo)){
      return JsonResult.buildErrorStateResult("获取TokenOnce失败", "");
    }
    String tokenOnce = UUID.randomUUID().toString();
    final String key = Constants.TOKEN_ONCE_KEY_FOR_PHONE + phoneNo;
    redisTemplate.opsForValue().set(key, tokenOnce, ONE_HOUR, TimeUnit.SECONDS);
    return JsonResult.buildSuccessResult("", tokenOnce);
  }

}
