package cn.quantgroup.xyqb.service.mq.Impl;

import cn.quantgroup.xyqb.model.UserStatistics;
import cn.quantgroup.xyqb.service.mq.IVestService;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by xuran on 2017/6/21.
 * 用户统计信息
 */
@Service("loanVestMQService")
public class LoanVestMQServiceImpl implements IVestService {
  private static final Logger LOGGER = LoggerFactory.getLogger(LoanVestMQServiceImpl.class);

  @Resource
  @Qualifier("rabbitTemplate")
  private RabbitTemplate loanVestRabbitTemplate;

  @Resource
  @Qualifier(value = "loanVestQueue")
  Queue loanVestQueue;

  /**
   * 发送用登陆统计信息
   * @param message 订单信息
   */
  @Override
  @Async
  public void send(UserStatistics message){
    if(null==message){
      LOGGER.error("用户登陆统计消息不能为空");
    }
    LOGGER.info("用户登陆统计发送,message={}",message);
    String msg  = JSONObject.toJSONString(message);
    loanVestRabbitTemplate.convertAndSend("statistics-user", msg);
    LOGGER.info("用户登陆统计成功,message={}",msg);
  }

}
