package cn.quantgroup.xyqb.controller.modifyphoneno;

import cn.quantgroup.xyqb.constant.UserConstant;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.controller.modifyphoneno.req.*;
import cn.quantgroup.xyqb.controller.modifyphoneno.req.ModifyPhoneRecord.UserClient;
import cn.quantgroup.xyqb.controller.modifyphoneno.resp.ModifyPhoneNoResp;
import cn.quantgroup.xyqb.controller.modifyphoneno.resp.ProgressResp;
import cn.quantgroup.xyqb.controller.modifyphoneno.resp.UserModifyPhoneRecordResp;
import cn.quantgroup.xyqb.entity.ModifyPhoneNo;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.user.IModifyPhoneNoService;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * 用户手机号修改相关api
 * <p>
 * Date: 2019/11/4
 * Time: 上午11:23
 *
 * @author: yangrui
 */
@RestController
@RequestMapping("/v1/user/modify/phone_no")
public class ModifyPhoneNoController implements IBaseController {

    @Resource
    private IModifyPhoneNoService modifyPhoneNoService;


    @GetMapping("/progress")
    public JsonResult<ProgressResp> progress() {
        User user = getCurrentUserFromRedis();
        if (user == null) {
            return JsonResult.buildErrorStateResult("系统错误", null);
        }
        return JsonResult.buildSuccessResultGeneric(modifyPhoneNoService.progress(user.getId()));
    }


    /**
     * step_1
     *
     * @param step1Req
     * @return
     */
    @PostMapping("/step_1")
    public JsonResult step1(@Valid @RequestBody Step1Req step1Req,@RequestParam(value = "tenantId",defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        User user = getCurrentUserFromRedis();
        if (user == null) {
            return JsonResult.buildErrorStateResult("系统错误", null);
        }
        return JsonResult.buildSuccessResultGeneric(modifyPhoneNoService.saveStep1(user.getId(), step1Req,tenantId));
    }

    /**
     * step_2
     *
     * @param step2Req
     * @return
     */
    @PostMapping("/step_2")
    public JsonResult step2(@Valid @RequestBody Step2Req step2Req) {
        modifyPhoneNoService.saveStep2(step2Req);
        return JsonResult.buildSuccessResult();
    }

    /*------------------------------------------------------------------------------------------------------------*/

    /**
     * 后台客服处理功能 - 查询列表
     */
    @GetMapping
    public JsonResult<?> list(@Valid ModifyPhoneNoQueryReq modifyPhoneNoQueryReq) {
        Page<ModifyPhoneNo> list = modifyPhoneNoService.list(modifyPhoneNoQueryReq);
        try {
            Page<ModifyPhoneNoResp> result = list.map(ModifyPhoneNoResp::from);
            return JsonResult.buildSuccessResultGeneric(result);
        } catch (Exception ignored) {
        }
        return JsonResult.buildErrorStateResult("数据错误",null);
    }

    /**
     * 后台客服处理功能 - 人工审核
     */
    @PostMapping("/audit")
    public JsonResult audit(@Valid @RequestBody AuditReq auditReq,@RequestParam(value = "tenantId",defaultValue = UserConstant.defaultTenantIdString) Integer tenantId) {
        modifyPhoneNoService.audit(auditReq,tenantId);
        return JsonResult.buildSuccessResult();
    }

    /**
     * 后台客服处理功能 - 反馈跟进
     */
    @PostMapping("/{id}/feedback")
    public JsonResult feedback(@PathVariable Long id) {
        modifyPhoneNoService.feedback(id);
        return JsonResult.buildSuccessResult();
    }

    /*------------------------------------------------------------------------------------------------------------*/

    /**
     * 客服系统修改手机号
     * @param modifyPhoneRecord
     * @return
     */
    @PostMapping("/submitModify")
    public JsonResult submitModify(@Valid @RequestBody ModifyPhoneRecord modifyPhoneRecord) {
        modifyPhoneNoService.submitModify(modifyPhoneRecord);
        return JsonResult.buildSuccessResult();
    }

    /**
     * 金融修改手机号
     * @param modifyPhoneRecord
     * @return
     */
    @PostMapping("/financial/submitModify")
    public JsonResult financialSubmitModify(@Valid @RequestBody ModifyPhoneRecord modifyPhoneRecord) {
        modifyPhoneNoService.financialSubmitModify(modifyPhoneRecord);
        return JsonResult.buildSuccessResult();
    }

    /**
     * 用户端修改手机号
     * @param modifyPhoneRecord
     * @return
     */
    @PostMapping("/client/submitModify")
    public JsonResult clientSubmitModify(@Validated(value = UserClient.class) @RequestBody ModifyPhoneRecord modifyPhoneRecord) {
        modifyPhoneNoService.clientSubmitModify(modifyPhoneRecord);
        return JsonResult.buildSuccessResult();
    }

    @PostMapping( "/modifyPhoneNolist")
    public JsonResult getModifyPhoneNolist(@RequestParam("userId") Long userId,
                                          @RequestParam(value = "pageNo", defaultValue = "1", required = false) int pageNo,
                                          @RequestParam(value = "pageSize", defaultValue = "10", required = false) int pageSize) {
        Page<UserModifyPhoneRecordResp> pageData = modifyPhoneNoService.query(userId, pageNo, pageSize).map(record -> {
            UserModifyPhoneRecordResp userModifyPhoneRecordResp = new UserModifyPhoneRecordResp();
            BeanUtils.copyProperties(record, userModifyPhoneRecordResp);
            userModifyPhoneRecordResp.setReason(record.getReason().name());
            return userModifyPhoneRecordResp;
        });

        return JsonResult.buildSuccessResult("修改手机号列表", pageData);
    }

    @GetMapping("/lastRecord")
    public JsonResult getLastRecord(@RequestParam("userId") Long userId){
        UserModifyPhoneRecordResp resp = modifyPhoneNoService.getLastRecord(userId);
        return JsonResult.buildSuccessResult("最后修改记录", resp);
    }

    @PostMapping("/rejectReason/save")
    public JsonResult saveRejectReason(@Valid @RequestBody ModifyRejectRecord modifyRejectRecord,@RequestParam(value = "tenantId",defaultValue = UserConstant.defaultTenantIdString) Integer tenantId){
        modifyPhoneNoService.saveRejectReason(modifyRejectRecord,tenantId);
        return JsonResult.buildSuccessResult("保存手机号修改失败原因成功");
    }

    @GetMapping("/modifyRecord")
    public JsonResult modifyRecord(@RequestParam("prevPhoneNo") String prevPhoneNo){
        UserModifyPhoneRecordResp resp = modifyPhoneNoService.modifyRecord(prevPhoneNo);
        return JsonResult.buildSuccessResult("手机号修改记录", resp);
    }

}
