package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.repository.IUserDetailRepository;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by 11 on 2016/12/29.
 */
@Service
public class UserDetailServiceImpl implements IUserDetailService {

    @Autowired
    private IUserDetailRepository userDetailRepository;

    @Override
    public UserDetail findByUserId(Long userId) {
        return userDetailRepository.findByUserId(userId);
    }

    @Override
    public UserDetail saveUserDetail(UserDetail userDetail) {
        return userDetailRepository.save(userDetail);
    }

    @Override
    public UserDetail findByPhoneNo(String phoneNo) {
        return userDetailRepository.findByPhoneNo(phoneNo);
    }

    @Override
    public void updateUserQQ(Long userId, String qq) {
        userDetailRepository.updateUserQQ(qq, userId);
    }
}
