package demo;

import org.junit.Test;
import org.junit.jupiter.api.Tag;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import java.util.Arrays;
import java.util.Collection;

/**
 * jUnit4风格参数化批量测试（用例）
 * @author renwc
 * @date 2018-01-05
 */
@Tag("Parameters")
@RunWith(value = Parameterized.class)
public class ParametersJunit4Test {
	private String key;
	private int value;
	public ParametersJunit4Test(String key, int value) {
		this.key = key;
		this.value = value;
	}

	@Parameterized.Parameters
	public static Collection<Object[]> data() {
		Object[][] data = new Object[][] {{"1", 1}, {"2", 2}, {"3", 3}, {"4", 4}};
		return Arrays.asList(data);
	}

	@Test
	public void pushTest() {
		System.out.println("Parameterized is : key="+ key+", value="+value);
	}

}