package cn.quantgroup.xyqb.entity;

import lombok.Data;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by 11 on 2016/12/30.
 */
@Data
@Entity
@Table(name = "user_query_log")
public class UserQueryLog implements Serializable {

    private static final long serialVersionUID = -1L;
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Basic(optional = false)
    private Long id;

    @Column(name = "login_user_name")
    private String loginUserName;
    @Column(name = "query_condition")
    private String queryCondition;
    @Column(name = "query_items")
    private String queryItems;
    @Column(name = "result_amount")
    private Long resultAmount;
    @Column(name = "query_detail")
    private String queryDetail;

    @Transient
    private String createDate;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @PrePersist
    public void prePersist() {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        this.createdAt = now;
    }
}
