package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.UserExtInfo;
import cn.quantgroup.xyqb.repository.IUserExtInfoRepository;
import cn.quantgroup.xyqb.service.user.IUserExtInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by Miraculous on 2017/1/3.
 */
@Service
public class UserExtInfoServiceImpl implements IUserExtInfoService {

  @Autowired
  private IUserExtInfoRepository userExtInfoRepository;

  @Override
  @Cacheable(value = "userextinfocache", key = "'extinfo' + #userId", unless = "#result == null", cacheManager = "cacheManager")
  public UserExtInfo findByUserId(Long userId) {
    return userExtInfoRepository.findByUserId(userId);
  }

  @Override
  @Transactional
  @CacheEvict(value = "userextinfocache", key = "'extinfo' + #info.userId", cacheManager = "cacheManager")
  public UserExtInfo save(UserExtInfo info) {
    return userExtInfoRepository.save(info);
  }

}
