package cn.quantgroup.xyqb.repository;


import cn.quantgroup.xyqb.entity.WechatInfoRelation;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

import static org.springframework.transaction.annotation.Propagation.MANDATORY;

public interface IWeChatInfoRelationRepository extends JpaRepository<WechatInfoRelation, Long> {

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update wechat_info_relation as wir set wir.is_follow_wechat = 1 where wir.open_id IN (?1)", nativeQuery = true)
    void updateIsFollowWechatInOpenIdList(List<String> openIdList);

    List<WechatInfoRelation> findByUnionIdInAndTaskPeriodAndType(List<String> unionIdList, String period, Integer type);

}
