package cn.quantgroup.xyqb.controller.internal.user.resp;

import cn.quantgroup.user.enums.BizType;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class UserFullResp {

    /**
     * userId : 1396263648485684
     * gender : 2
     * idType : 6
     * idNo : aliqua esse
     * name : sunt consectetur nisi
     * phoneNo : non consectetur dolore ea
     * uuid : qui dolor ipsum minim
     * incomeRange : 1
     * incomeType : 2
     * qq : exercitation eu
     * email : s
     * hasSocialSecurity : 0
     * hasCar : 1
     * education : 3
     * occupation : 7
     * hasCreditCard : 1
     * hasHouse : 1
     * marryStatus : 1
     */

    private Long userId;
    private Integer gender;
    private Integer idType;
    private String idNo;
    private String name;
    private String phoneNo;
    private String uuid;
    private Integer incomeRange;
    private Integer incomeType;
    private String qq;
    private String email;
    private Integer hasSocialSecurity;
    private Integer hasCar;
    private Integer education;
    private Integer occupation;
    private Integer hasCreditCard;
    private Integer hasHouse;
    private Integer marryStatus;

    /**
     * districtCode : do adipisicing minim sit deserunt
     * city : enim ipsum voluptate do
     * cityCode : voluptate
     * province : mollit
     * provinceCode : sint culpa in laborum
     * address : ut nostrud incididunt
     * district : incididunt ullamco dolore in
     */

    private Long districtCode;
    private String city;
    private Long cityCode;
    private String province;
    private Long provinceCode;
    private String address;
    private String district;

    private List<Contact> contacts;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Contact {

        /**
         * userId : 4069695050527240
         * name : ex reprehenderit dolore dol
         * mobile : fugiat quis ad veniam dolor
         * relation : 1
         */

        private Long userId;
        private String name;
        private String mobile;
        private Integer relation;
        private BizType bizType;
    }
}
